<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-briefcase me-2"></i>Kelola Pengalaman Kerja
    </h2>
    <a href="<?= base_url('admin/work/create') ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle me-1"></i>Tambah Pengalaman Kerja
    </a>
</div>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle me-2"></i><?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle me-2"></i><?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Search and Filter Section -->
<div class="admin-card">
    <form method="GET" action="<?= base_url('admin/work') ?>" class="row g-3">
        <div class="col-md-3">
            <label for="search" class="form-label">Cari Pengalaman Kerja</label>
            <input type="text" class="form-control" id="search" name="search" 
                   value="<?= esc($search) ?>" placeholder="Cari perusahaan, posisi...">
        </div>
        <div class="col-md-2">
            <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
            <input type="number" class="form-control" id="tahun_mulai" name="tahun_mulai" 
                   value="<?= esc($filter['tahun_mulai']) ?>" placeholder="Tahun mulai...">
        </div>
        <div class="col-md-2">
            <label for="tahun_selesai" class="form-label">Tahun Selesai</label>
            <input type="number" class="form-control" id="tahun_selesai" name="tahun_selesai" 
                   value="<?= esc($filter['tahun_selesai']) ?>" placeholder="Tahun selesai...">
        </div>
        <div class="col-md-2">
            <label for="sort" class="form-label">Sort By</label>
            <select class="form-select" id="sort" name="sort">
                <option value="urutan" <?= $sort === 'urutan' ? 'selected' : '' ?>>Urutan</option>
                <option value="nama_perusahaan" <?= $sort === 'nama_perusahaan' ? 'selected' : '' ?>>Nama Perusahaan</option>
                <option value="tahun_mulai" <?= $sort === 'tahun_mulai' ? 'selected' : '' ?>>Tahun Mulai</option>
            </select>
        </div>
        <div class="col-md-1">
            <label for="order" class="form-label">Order</label>
            <select class="form-select" id="order" name="order">
                <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>ASC</option>
                <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>DESC</option>
            </select>
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
                <i class="bi bi-funnel"></i>
            </button>
        </div>
    </form>
</div>

<!-- Work Experience Table -->
<div class="admin-card">
    <?php if (empty($work)): ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle me-2"></i>Tidak ada pengalaman kerja yang ditemukan.
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>
                            <a href="<?= base_url('admin/work?sort=urutan&order=' . ($sort === 'urutan' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Urutan <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>
                            <a href="<?= base_url('admin/work?sort=nama_perusahaan&order=' . ($sort === 'nama_perusahaan' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Perusahaan <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>Posisi</th>
                        <th>
                            <a href="<?= base_url('admin/work?sort=tahun_mulai&order=' . ($sort === 'tahun_mulai' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Tahun <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = ($pager->getCurrentPage() - 1) * 10 + 1; ?>
                    <?php foreach ($work as $w): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= esc($w['urutan']) ?></td>
                            <td><?= esc($w['nama_perusahaan']) ?></td>
                            <td><?= esc($w['posisi']) ?></td>
                            <td>
                                <?php if ($w['tahun_mulai'] && $w['tahun_selesai']): ?>
                                    <?= esc($w['tahun_mulai']) ?> - <?= esc($w['tahun_selesai']) ?>
                                <?php elseif ($w['tahun_mulai']): ?>
                                    <?= esc($w['tahun_mulai']) ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?= base_url('admin/work/edit/' . $w['id']) ?>" 
                                   class="btn btn-sm btn-warning btn-action">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="<?= base_url('admin/work/delete/' . $w['id']) ?>" 
                                   class="btn btn-sm btn-danger btn-action"
                                   onclick="return confirm('Yakin ingin menghapus pengalaman kerja ini?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($pager->getLastPage() > 1): ?>
            <nav aria-label="Page navigation" class="mt-4">
                <ul class="pagination">
                    <?php if ($pager->getCurrentPage() > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/work?page=' . ($pager->getCurrentPage() - 1) . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php for ($i = 1; $i <= $pager->getLastPage(); $i++): ?>
                        <li class="page-item <?= $i == $pager->getCurrentPage() ? 'active' : '' ?>">
                            <a class="page-link" href="<?= base_url('admin/work?page=' . $i . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                Part <?= $i ?>
                            </a>
                        </li>
                    <?php endfor; ?>
                    
                    <?php if ($pager->getCurrentPage() < $pager->getLastPage()): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/work?page=' . ($pager->getCurrentPage() + 1) . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>


